﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace maze
{
    class Cell
    {
        List<Cell> _neighbors;
        List<Cell> _linked;
        bool _isVisited;

        public Cell()
        {
            _neighbors = new List<Cell>();
            _linked = new List<Cell>();
            _isVisited = false;
        }

        public List<Cell> Neighbors
        {
            get { return _neighbors; }
        }

        public List<Cell> Linked
        {
            get { return _linked; }
        }

        public bool IsVisited
        {
            get { return _isVisited; }
            set { _isVisited = value; }
        }

        public void addNeighbor(Cell c)
        {
            _neighbors.Add(c);
        }

        public void addLink(Cell c)
        {
            if (!this.isNeighbor(c))
                throw new MazeException("The cells cannot be linked because there are not neighbors");
            _linked.Add(c);
        }

        public bool isNeighbor(Cell c)
        {
            return _neighbors.Contains(c);
        }

        public bool isLink(Cell c)
        {
            return _linked.Contains(c);
        }

        public void randomizeNeighbors(Random rng)
        {
            for (int i = 0; i < _neighbors.Count; ++i)
            {
                int k = rng.Next(_neighbors.Count - 1);
                Cell tmp = _neighbors[i];
                _neighbors[i] = _neighbors[k];
                _neighbors[k] = tmp;
            }
        }
    }
}
