﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace maze
{
    class Maze
    {
        int _width, _height;
        Cell[,] _cells;
        Random _rnd;

        public Maze(int width, int height)
        {
            if ((width <= 0) || (height <= 0))
                throw new MazeException("You fools! Dimensions cannot be equal or less than zero!");
            if ((width > 100) || (height > 100))
                throw new MazeException("This is too big!");

            _width = width;
            _height = height;
            _cells = new Cell[_width, _height];
            for (int i = 0; i < _width; ++i)
                for (int j = 0; j < _height; ++j)
                    _cells[i, j] = new Cell();
            addNeighbors();
            _rnd = new Random();
        }

        void addNeighbors()
        {
            for (int i = 0; i < _width; ++i)
            {
                for (int j = 0; j < _height; ++j)
                {
                    if (i > 0)
                        _cells[i, j].addNeighbor(_cells[i - 1, j]);
                    if (i < _width - 1)
                        _cells[i, j].addNeighbor(_cells[i + 1, j]);
                    if (j > 0)
                        _cells[i, j].addNeighbor(_cells[i, j - 1]);
                    if (j < _height - 1)
                        _cells[i, j].addNeighbor(_cells[i, j + 1]);
                }
            }
        }

        void generate_rec(Cell c)
        {
            c.IsVisited = true;
            c.randomizeNeighbors(_rnd);

            foreach (Cell c2 in c.Neighbors)
            {
                if (!c2.IsVisited)
                {
                    c.addLink(c2);
                    c2.addLink(c);
                    generate_rec(c2);
                }
            }
        }

        public void generate()
        {
            int i = _rnd.Next(_width - 1);
            int j = _rnd.Next(_height - 1);
            generate_rec(_cells[i, j]);
        }

        bool solve_rec(Cell start, Cell end, List<Cell> path)
        {
            if (start == end)
                return true;
            else
            {
                start.IsVisited = true;
                start.randomizeNeighbors(_rnd);
                foreach (Cell c in start.Linked)
                    if (!c.IsVisited)
                        if (solve_rec(c, end, path))
                        {
                            path.Add(c);
                            return true;
                        }
            }
            return false;
        }

        public List<Cell> solve()
        {
            foreach (Cell c in _cells)
                c.IsVisited = false;
            List<Cell> path = new List<Cell>();
            solve_rec(_cells[0, 0], _cells[_width - 1, _height - 1], path);
            path.Add(_cells[0, 0]);
            return path;
        }

        void print_line()
        {
            Console.Write(' ');
            for (int i = 0; i < _width * 2 + 1; ++i)
                Console.Write('-');
            Console.WriteLine();
        }

        public void print(List<Cell> path)
        {
            print_line();
            for (int j = 0; j < _height; ++j)
            {
                Console.Write(' ');
                Console.Write('|');
                Console.SetCursorPosition(Console.CursorLeft - 2, Console.CursorTop + 1);
                Console.Write(' ');
                Console.Write('|');
                Console.SetCursorPosition(Console.CursorLeft, Console.CursorTop - 1);
                for (int i = 0; i < _width; ++i)
                {
                    if (path.Contains(_cells[i, j]))
                    {
                        Console.ForegroundColor = ConsoleColor.Red;
                        Console.Write('.');
                        Console.ForegroundColor = ConsoleColor.White;
                    }
                    else
                        Console.Write(' ');
                    if ((i == _width - 1) || !_cells[i, j].isLink(_cells[i + 1, j]))
                    {
                        Console.Write('|');
                        Console.SetCursorPosition(Console.CursorLeft - 1, Console.CursorTop + 1);
                        Console.Write('|');
                        Console.SetCursorPosition(Console.CursorLeft, Console.CursorTop - 1);
                    }
                    else
                        Console.Write(' ');
                    if ((j == _height - 1) || !_cells[i, j].isLink(_cells[i, j + 1]))
                    {
                        Console.SetCursorPosition(Console.CursorLeft - 3, Console.CursorTop + 1);
                        if (i == 0)
                            Console.Write("|--");
                        else
                            Console.Write("---");
                        Console.SetCursorPosition(Console.CursorLeft, Console.CursorTop - 1);
                    }

                }
                Console.SetCursorPosition(Console.CursorLeft - 1, Console.CursorTop + 1);
                Console.Write('|');
                Console.SetCursorPosition(Console.CursorLeft, Console.CursorTop - 1);
                Console.SetCursorPosition(0, Console.CursorTop + 2);
            }
        }

        public void print()
        {
            print_line();
            for (int j = 0; j < _height; ++j)
            {
                Console.Write(' ');
                Console.Write('|');
                Console.SetCursorPosition(Console.CursorLeft - 2, Console.CursorTop + 1);
                Console.Write(' ');
                Console.Write('|');
                Console.SetCursorPosition(Console.CursorLeft, Console.CursorTop - 1);
                for (int i = 0; i < _width; ++i)
                {
                    Console.Write(' ');
                    if ((i == _width - 1) || !_cells[i, j].isLink(_cells[i + 1, j]))
                    {
                        Console.Write('|');
                        Console.SetCursorPosition(Console.CursorLeft - 1, Console.CursorTop + 1);
                        Console.Write('|');
                        Console.SetCursorPosition(Console.CursorLeft, Console.CursorTop - 1);
                    }
                    else
                        Console.Write(' ');
                    if ((j == _height - 1) || !_cells[i, j].isLink(_cells[i, j + 1]))
                    {
                        Console.SetCursorPosition(Console.CursorLeft - 3, Console.CursorTop + 1);
                        if (i == 0)
                            Console.Write("|--");
                        else
                            Console.Write("---");
                        Console.SetCursorPosition(Console.CursorLeft, Console.CursorTop - 1);
                    }

                }
                Console.SetCursorPosition(Console.CursorLeft - 1, Console.CursorTop + 1);
                Console.Write('|');
                Console.SetCursorPosition(Console.CursorLeft, Console.CursorTop - 1);
                Console.SetCursorPosition(0, Console.CursorTop + 2);
            }
        }
    }
}
