﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;

namespace debugger1
{
  class Debugger
  {
    SpriteBatch sb;
    SpriteFont font;
    List<Texture2D> imgs = new List<Texture2D>();
    int cmt = 0;
    const int delay = 10;
    int img_index = 0;

    public Debugger(SpriteBatch sb, ContentManager content)
    {
      this.sb = sb;
      this.font = content.Load<SpriteFont>("font");
      imgs.Add(content.Load<Texture2D>("troll1"));
      imgs.Add(content.Load<Texture2D>("troll2"));
    }

    private void update_anim()
    {
      cmt++;
      if (cmt > delay)
      {
        cmt = 0;
        img_index = 2 - img_index;
      }
    }

    public void run()
    {
      update_anim();

      for (int i = 0; i < 4; i++)
        for (int j = 0; j < 14; j++)
        {
          draw(j * (49 + i * 2), 180 + 30 * i, Color.White, (0.4f + 0.2f * i));
        }
    }

    private void draw(int x, int y, Color c, float size)
    {
      sb.Draw(imgs[img_index], new Vector2(x,y), null, c, 0, new Vector2(0), size, SpriteEffects.None, 0);
    }

  }
}
