﻿using System;
using System.Net.Sockets;
using System.IO;

namespace ServerWPF
{
    class Client
    {
        public String name { get; private set; }
        private String host;
        private int port;

        public Socket sock { get; private set; }

        private StreamReader clientReader;
        private StreamWriter clientWriter;

        public Client(String name, String host, int port, Socket sock)
        {
            this.name = name;
            this.host = host;
            this.port = port;
            this.sock = sock;

            this.clientReader = new StreamReader(new NetworkStream(sock));
            this.clientWriter = new StreamWriter(new NetworkStream(sock));
        }

        public void Send(string message)
        {
            clientWriter.WriteLine(message);
            clientWriter.Flush();
        }

        public string Receive()
        {
            string message;
            try
            {
                message = clientReader.ReadLine();
                return message;
            }
            catch
            {
                return null;
            }
        }

        public void Close()
        {
            this.clientReader.Close();
            this.clientWriter.Flush();
            this.clientWriter.Close();
            this.sock.Close();
        }

        public void SetName()
        {
            this.name = clientReader.ReadLine();
        }

        public override string ToString()
        {
            return this.name + ":" + this.host;
        }
    }
}
