﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace ServerWPF
{
    /// <summary>
    /// Logique d'interaction pour MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        Server server = null;

        public MainWindow()
        {
            InitializeComponent();
            ChatBox.VerticalScrollBarVisibility = ScrollBarVisibility.Auto;
            LogBox.VerticalScrollBarVisibility = ScrollBarVisibility.Auto;
            ChatBox.ScrollToEnd();
        }

        private void LaunchButton_Click(object sender, RoutedEventArgs e)
        {
            ClientList.DisplayMemberPath = "name";
            if (server != null)
                server.Close();
            server = new Server(4242, this);
            server.Run();
        }

        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            if (server != null)
                server.Close();
        }

        private void Blacklist_Click(object sender, RoutedEventArgs e)
        {
            if (server != null)
                server.Blacklist((Client)ClientList.SelectedItem);
        }
    }
}
