﻿using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Net.Sockets;
using System.Net;

namespace ServerWPF
{
    class Server
    {
        delegate void chatdelegate(string text);
        delegate void logdelegate(string text);
        delegate void listdelegate(Client client);
        private LinkedList<Client> clients;
        private LinkedList<IPAddress> blacklist;

        private Thread clientsThread;
        private Thread clientsChat;
        private Socket socket;

        MainWindow window;

        public Server(int port, MainWindow window)
        {
            socket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
            socket.Bind(new IPEndPoint(IPAddress.Any, port));
            clients = new LinkedList<Client>();
            blacklist = new LinkedList<IPAddress>();
            socket.Listen(35);
            this.window = window;
            logdelegate logtext = SetLogText;
            IPEndPoint endpoint = (IPEndPoint)socket.LocalEndPoint;
            window.Dispatcher.Invoke(logtext, "Connected on IP " + LocalIPAddress()
                 + ", Port : " + endpoint.Port);
        }

        public string LocalIPAddress()
        {
            IPHostEntry host;
            string localIP = "";
            host = Dns.GetHostEntry(Dns.GetHostName());
            foreach (IPAddress ip in host.AddressList)
            {
                if (ip.AddressFamily == AddressFamily.InterNetwork)
                    localIP = ip.ToString();
            }
            return localIP;
        }

        public void Run()
        {
            clientsThread = new Thread(new ThreadStart(AcceptClient));
            clientsThread.Start();
            clientsChat = new Thread(new ThreadStart(Chat));
            clientsChat.Start();
        }

        private void SetChatText(string text)
        {
           window.ChatBox.Text += text + "\n";
           window.ChatBox.ScrollToEnd();
        }

        private void SetLogText(string text)
        {
            window.LogBox.Text += text + "\n";
        }

        private void AddClient(Client client)
        {
            window.ClientList.Items.Add(client);
        }

        private void RemoveClient(Client client)
        {
            window.ClientList.Items.Remove(client);
        }


        private void AcceptClient()
        {
            while (true)
            {
                Socket client = null;
                try
                {
                    client = socket.Accept();
                }
                catch (SocketException)
                {
                    return;
                }

                // Use the socket client to do whatever you want to do
                IPEndPoint remote = (IPEndPoint)client.RemoteEndPoint;
                Client myClient = new Client("Jojo", remote.Address.ToString(), remote.Port, client);
                myClient.SetName();

                if (blacklist.Contains(remote.Address))
                {
                    myClient.Send("You're blacklisted, get lost !");
                    myClient.Close();
                    continue;
                }
                else
                    myClient.Send("Welcome");

                clients.AddLast(myClient);
                listdelegate listadd = AddClient;
                window.Dispatcher.Invoke(listadd, myClient);

                logdelegate logtext = SetLogText;
                window.Dispatcher.Invoke(logtext, "Connexion from " + myClient.name);
            }
        }

        private void Chat()
        {
            while (true)
            {
                if (clients.Count == 0)
                    continue;

                for (int i = 0; i < clients.Count; i++)
                {
                    Client client = clients.ElementAt(i);

                    if (client.sock.Poll(1, SelectMode.SelectRead))
                    {
                        string message = client.Receive();

                        if (message == null)
                        {
                            logdelegate logtext = SetLogText;
                            window.Dispatcher.Invoke(logtext, "Client " + client.name + " disconnected");
                            clients.Remove(client);
                            listdelegate listdel = RemoveClient;
                            window.Dispatcher.Invoke(listdel, client);
                            continue;
                        }

                        if (message.Length == 0)
                            continue;

                        chatdelegate chattext = SetChatText;
                        window.Dispatcher.Invoke(chattext, client.name + " : " + message);
                        foreach (Client sclient in clients)
                            sclient.Send(client.name + ": " + message);
                    }
                }
            }
        }

        public void Close()
        {
            foreach (Client client in clients)
            {
                listdelegate listdel = RemoveClient;
                window.Dispatcher.Invoke(listdel, client);
                client.Send("closing");
                client.Close();
            }

            clientsChat.Abort();
            clientsThread.Abort();
            logdelegate log = SetLogText;
            window.Dispatcher.Invoke(log, "Server closing...");

            socket.Close();
        }


        public void Blacklist(Client client)
        {
            if (client != null)
            {
                blacklist.AddLast(((IPEndPoint)client.sock.LocalEndPoint).Address);
                client.Close();
                clients.Remove(client);
                listdelegate listdel = RemoveClient;
                window.Dispatcher.Invoke(listdel, client);
            }
        }
    }
}
