using System;

namespace mymagicarray
{
	public delegate T mapDelegate<T> (T elt);
	public delegate bool boolDelegate<T> (T elt);
	class MyMagicArray<T> where T : IComparable
	{
		T[] tab;
		int nb_elts;

		public MyMagicArray (int size_max)
		{
			tab = new T[size_max];
			nb_elts = 0;
		}

		public void Insert (T elt)
		{
			if (nb_elts == tab.GetLength(0)) 
			{
				T[] new_tab = new T[tab.GetLength(0) * 2];
				for (int i = 0; i < nb_elts; i++)
				{
					new_tab[i] = tab[i];
				}
				nb_elts++;
			} 
			else
			{
				tab [nb_elts] = elt;
				nb_elts++;
			}
		}

		public bool Delete (T elt)
		{
			for (int i = 0; i < nb_elts; i++)
			{
				if (tab[i].CompareTo(elt) == 0)
				{
					for (int j = i; j < nb_elts - 1; j++)
					{
						tab[j] = tab[j + 1];
					}
					nb_elts--;
					return true;
				}
			}
			return false;
		}

		public T At (int i)
		{
			try
			{
				return tab[i];
			}
			catch (IndexOutOfRangeException e)
			{
				Console.WriteLine(e.Message);
				return default(T);
			}
		}

		public void Map (mapDelegate<T> funct)
		{
			foreach (T elt in tab)
			{
				funct(elt);
			}
		}

		public void Quicksort (int left, int right)
		{
			int i = left;
			int j = right;
			T pivot = tab[(left + right) / 2];
			
			while (i <= j)
			{
				while (tab[i].CompareTo(pivot) < 0)
				{
					i++;
				}
				
				while (tab[j].CompareTo(pivot) > 0)
				{
					j--;
				}
				
				if (i <= j)
				{
					// Swap
					T tmp = tab[i];
					tab[i] = tab[j];
					tab[j] = tmp;
					
					i++;
					j--;
				}
			}
			
			// Recursive calls
			if (left < j)
			{
				Quicksort(left, j);
			}
			
			if (i < right)
			{
				Quicksort(i, right);
			}
		}

		public void Print (boolDelegate<T> predicat)
		{
			for (int i = 0; i < nb_elts - 1; i++) 
			{
				if (predicat (tab [i]))
					Console.ForegroundColor = ConsoleColor.Green;
				else
					Console.ForegroundColor = ConsoleColor.Red;
				Console.Write (tab [i]);
				Console.ForegroundColor = ConsoleColor.White;
				Console.Write (", ");
			}
			if (predicat (tab [nb_elts - 1]))
				Console.ForegroundColor = ConsoleColor.Green;
			else
				Console.ForegroundColor = ConsoleColor.Red;

			Console.WriteLine (tab [nb_elts - 1]);
		}
	}

	class Program
	{
		public static void Main(string[] args)
		{
			MyMagicArray<int> empanadas = new MyMagicArray<int>(10);
			empanadas.Insert(4777);
			empanadas.Insert(1231234);
			empanadas.Insert(47);
			empanadas.Insert(45);
			empanadas.Insert(43);
			empanadas.Insert(41);
			empanadas.Insert(14);
			empanadas.Insert(42);
			// Print en vert si pair, print en rouge sinon
			empanadas.Print(x => x % 2 == 0);

		}
	}
}
